#include <allegro.h>
#include <stdarg.h>
#include <stdio.h>
#include <math.h>

#include "main.h"
#include "text.h"
#include "game.h"


char *prompt(BITMAP *bmp, char *string, int max_len, int x, int y, int fg, int bg, char *format, ...)
{	
	BITMAP *buffer;
	char str_buffer[1024];
	int k,c;
	int len;

	va_list args;
	va_start(args, format);
	_vsnprintf(str_buffer, 1024, format, args);
	va_end(args);
	str_buffer[1023] = 0;

	len = strlen(string);

	while (1)
	{
		game_poll();

		buffer = gfx_frame_start(gfx);
		if (bmp) blit(bmp, buffer, 0,0, 0,0, bmp->w, bmp->h);
		textprintf_ex(buffer, font64, x,y, fg,bg, "%s %s", str_buffer, string);	
		textprintf_ex(buffer, font64, x+8*(strlen(str_buffer)+strlen(string)+1),y, bg,fg, " ");
		gfx_frame_end(gfx);

		if (keypressed())
		{
			k = readkey();
			c = k >> 8;
			k = k & 0xff;

			if (c == KEY_BACKSPACE)
			{
				if (len > 0) string[--len] = 0;	
			}
			else if (c == KEY_ENTER)
			{
				if (len > 0 || format[0] == 0) break;
			}
			else if (k >= ' ' && k <= 'z')
			{
				if (len < max_len - 1)
				{
					if (k > 'Z') k -= 'a' - 'A';
					string[len++] = k;
					string[len] = 0;
				}
			}
		}
	}

	buffer = gfx_frame_start(gfx);
	if (bmp) blit(bmp, buffer, 0,0, 0,0, bmp->w, bmp->h);
	textprintf_ex(buffer, font64, x,y, fg,bg, "%s %s", str_buffer, string);	
	gfx_frame_end(gfx);

	return NULL;
}


int prompt_int(BITMAP *bmp, int min, int max, int x, int y, int fg, int bg, char *format, ... )
{	
	BITMAP *buffer;
	char str_buffer[1024];
	char string[20];
	int k,c;
	int len, max_len = log10(max) + 2;

	va_list args;
	va_start(args, format);
	_vsnprintf(str_buffer, 1024, format, args);
	va_end(args);
	str_buffer[1023] = 0;

	string[0] = 0;
	len = 0;

	
	while (1)
	{
		buffer = gfx_frame_start(gfx);
		if (bmp) blit(bmp, buffer, 0,0, 0,0, bmp->w, bmp->h);
		textprintf_ex(buffer, font64, x,y, fg,bg, "%s %s", str_buffer, string);
		textprintf_ex(buffer, font64, x+8*(strlen(str_buffer)+strlen(string)+1),y, bg,fg, " ");
		gfx_frame_end(gfx);

		k = game_readkey();
		c = k >> 8;
		k = k & 0xff;

		if (c == KEY_BACKSPACE)
		{
			if (len > 0) string[--len] = 0;			
		}
		else if (c == KEY_ENTER)
		{
			int value = atoi(string);
			if (len > 0 && value >= min && value <= max) break;
		}
		else if (k >= '0' && k <= '9')
		{
			if (len < max_len - 1)
			{
				string[len++] = k;
				string[len] = 0;
			}
		}
	}

	buffer = gfx_frame_start(gfx);
	if (bmp) blit(bmp, buffer, 0,0, 0,0, bmp->w, bmp->h);
	textprintf_ex(buffer, font64, x,y, fg,bg, "%s %s", str_buffer, string);	
	gfx_frame_end(gfx);

	return atoi(string);
}
